unit cdemo_rf;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  Tfrm_demo_rf = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    Button3: TButton;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    Button6: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    function convertChararrToHexstr(chararr:array of char;cnt: Integer):string ;
    procedure FormCreate(Sender: TObject);
    function  showMsg(msg:string):integer;
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frm_demo_rf:Tfrm_demo_rf;
  hexkey2:pchar;
  tagtype :Longint;
  snr:longword;
  data32:pchar;
  databuff32,datadevstr:pchar;
  rvalue:Longint;
  wvalue:Longint;
  cardmode:Integer;
  loadmode:Integer;
  sector:Integer;
  tempint:longword;
  st:smallint;
  readdata:array[0..32]of char;
  curCardType:Integer;
  relen:integer;//the lenght of command returned
  rebuf:array[0..32]of char;
  cmdstr:array[0..500]of char;
  cmdbuf:array[0..256]of char;
  revbuf:array[0..256]of char;
  showbuf:array[0..500]of char;
  tt:integer;
  fg:integer;
  summsg:string;

  hdevs:Array [0..9] of integer=(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1);    //in case of less than 10 reader
implementation

uses drv_unit;

{$R *.DFM}
function Tfrm_demo_rf.convertChararrToHexstr(chararr:array of char;cnt: Integer):string;
var
 str:string;
 tempstr:string;
 I:integer;
begin

for I := 0 to cnt-1 do
begin
tempstr:=inttohex(integer(chararr[i]),2);
str:=str+tempstr;
end;

Result:=str;
end;

function  Tfrm_demo_rf.showMsg(msg:string):integer;

begin
summsg:=msg+summsg;
summsg:=#13#10+summsg  ;
Memo2.Text:=summsg;
Result:= 1;
end;

procedure Tfrm_demo_rf.Button1Click(Sender: TObject);
var
 tmpdev:integer;
 i:integer;

begin
if CheckBox1.Checked=true then begin

//if more than one readers power on, repeat call fw_init can get handle of each reader
 i:=0;
 repeat
 tmpdev:=fw_init(100,0);

 if tmpdev>0 then begin
 hdevs[i]:=tmpdev;
 i:=i+1;
 end;

 until (tmpdev<0);

 icdev:=hdevs[0];


end

else begin
icdev:=fw_init(0,115200); //COM1baut rate: 115200
end;

  If icdev < 0 Then begin

      Memo2.Text:=('Call fw_init() function error!');
      exit;
 end
   else  begin
   Memo2.Text:=('Call fw_init() function OK!');


   try
  //  fw_setcpu(icdev,3);//for test
    except
    end;


   end;



  end;

procedure Tfrm_demo_rf.Button2Click(Sender: TObject);//RF Reset
var   keyarr : Array [0..6] of char  ;
begin
 st:=fw_reset(icdev, 2);
 If st <> 0 Then begin
      Memo2.Text:=('Call fw_reset() function error!');
      exit;
 end;

 Memo2.Text:=('Call fw_reset() function OK!');

 end;

procedure Tfrm_demo_rf.Button3Click(Sender: TObject);
 var
 sendbuf: Array[0..16] of char;
 str:string;
 value:LongWord;

begin


case curCardType of

0,1,2,3:
  begin

 st := fw_cpureset(icdev,@relen,rebuf);
 If st <> 0 Then begin
      Memo2.Text:=('Call fw_cpureset() function error');
      Exit;
 End;

 Memo2.Text:=('Call fw_cpureset() function success');
 str:=convertChararrToHexstr(rebuf, integer(relen));
 Memo2.Text:=('Information returned: '+str);
End;

4:
  begin

 cardmode := 1;//value 1: repeat find card,value 0: must take away the card before redo
 st :=fw_config_card(icdev , 65 );
 st := fw_card(icdev,cardmode,tempint);
 If st <> 0 Then begin
      Memo2.Text:=('Call fw_card() function error');
      Exit;
 End;

 showMsg('Call fw_card() function OK');
 showMsg('Card Serial number:'+inttostr(tempint));

  st:=fw_pro_reset(icdev,@relen,rebuf);
  If st <> 0 Then begin
      Memo2.Text:=('Call fw_pro_reset() function error');
      Exit;
 End;


 showMsg('Call fw_pro_reset() function OK');
 str:='';
 str:=convertChararrToHexstr(rebuf, integer(relen));
 showMsg('Information returned: '+str);

 End;



 else
 End;
 

end;

procedure Tfrm_demo_rf.Button5Click(Sender: TObject);
 var
 i:integer;
 cmdlen:integer;

begin

case curCardType of
0,1,2,3:
begin
 i:=0;

 repeat
 case i of
 0:
 begin
 strpcopy(@cmdstr[0],'00A40000022F02');
 cmdlen:=Length('00A40000022F02');
 end;
 1:
  begin
 strpcopy(@cmdstr[0],'00A4020002ef02');
 cmdlen:=Length('00A4020002ef02');
 end;
 2:
 begin
 strpcopy(@cmdstr[0],'002000000412345678');
 cmdlen:=Length('002000000412345678');
 end;
 3:
  begin
 strpcopy(@cmdstr[0],'00d600003c112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788112233445566778811223344');
 cmdlen:=Length('00d600003c112233445566778811223344556677881122334455667788112233445566778811223344556677881122334455667788112233445566778811223344');
 end;
 4:
 begin
 strpcopy(@cmdstr[0],'00b000003c');
 cmdlen:=Length('00b000003c');
 end;

 end;  //case i of
 showMsg('Send Command: '+cmdstr);
 a_hex(cmdbuf,cmdstr,cmdlen div 2);

 st:=fw_cpuapdu(icdev, (cmdlen div 2),cmdbuf,@relen,revbuf);

 if st<>0 then begin
 showMsg('Command execute failed');
 end;

 fillchar(showbuf,500,0);
 hex_a(showbuf,revbuf,integer(relen*2));
 showMsg('Returned: '+  showbuf);


 i:=i+1;

 until i=5;

 end;
4:
begin
  if Memo1.Text<>''then begin
  strpcopy(@cmdstr,Memo1.Text);
  cmdlen:=Length(Memo1.Text);
  a_hex(cmdbuf,cmdstr,cmdlen div 2);
  
  tt:=9;  //relay time 90ms
  fg:=60; //60 bytes lenght each command
  st:=fw_pro_commandlink(icdev,(cmdlen div 2),cmdbuf,@relen,revbuf,tt,fg);
  if st=0 then begin

  fillchar(showbuf,500,0);
  hex_a(showbuf,revbuf,integer(relen*2));
  showMsg(showbuf);

  end;
  end
  else
  Application.MessageBox('Enter Command please!','Demo',MB_OK);

end;

end;

end;
procedure Tfrm_demo_rf.Button4Click(Sender: TObject);
begin
quit();
close
end;


procedure Tfrm_demo_rf.FormCreate(Sender: TObject);
begin
ComboBox1.ItemIndex:=0 ;
Memo1.Text:='';
Memo2.Text:='';
curCardType:=0;

end;



procedure Tfrm_demo_rf.Button7Click(Sender: TObject);
begin

curCardType:=ComboBox1.ItemIndex;

case curCardType of
0:
begin
st:=fw_setcpu(icdev,12);

if st <>0 then
showMsg('Setup CPU card error');

end;

1:
begin

st:=fw_setcpu(icdev,13);

if st <>0 then
showMsg('Setup CPU card error');

end;

2:
begin

end;
3:
begin
end;

else
end;


end;//begin

procedure Tfrm_demo_rf.Button6Click(Sender: TObject);
begin
Memo2.Text:='';
summsg:='';
end;

procedure Tfrm_demo_rf.ComboBox1Change(Sender: TObject);
begin

curCardType:=ComboBox1.ItemIndex;

end;

end.
